namespace Microsoft.Samples.PlanMyNight.Web
{
    using System.ComponentModel.Composition;
    using System.Web;
    using Microsoft.Samples.PlanMyNight.Data;
    using Microsoft.Samples.PlanMyNight.Entities;

    [Export(typeof(IItineraryContainer))]
    [PartCreationPolicy(CreationPolicy.NonShared)]
    public class SessionItineraryContainer : IItineraryContainer
    {
        private readonly HttpContextBase httpContext;

        public SessionItineraryContainer() :
            this(new HttpContextWrapper(HttpContext.Current))
        {
        }
        
        public SessionItineraryContainer(HttpContextBase httpContext)
        {
            this.httpContext = httpContext;
        }

        public Itinerary GetCurrent()
        {
            return this.httpContext.Session["CurrentItinerary"] as Itinerary;
        }

        public void SetCurrent(Itinerary itinerary)
        {
            this.httpContext.Session["CurrentItinerary"] = itinerary;
        }
    }
}
